////////////////////////////////////////////////////////////////////////////////
//
// Example of how to use antidump PELOCK_MEMORY_GAP macro
//
// Version        : PELock v2.0
// Language       : Delphi/Pascal
// Author         : Bartosz Wjcik (support@pelock.com)
// Web page       : https://www.pelock.com
//
////////////////////////////////////////////////////////////////////////////////

//
// in order to use PELock unit and PELock macros you need to copy its files to
// the application directory or you can add unit and macro's path to the:
//
// Menu -> Tools -> Environment Options -> Library -> Library path
//
unit gui;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TfrmMain = class(TForm)
    lblInfo: TLabel;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.Button1Click(Sender: TObject);
begin

  frmMain.Close;

end;

procedure TfrmMain.FormShow(Sender: TObject);
begin

  // this macro will create a 'memory hole' within your application
  // process space, this hole will be unavailable to the application
  // itself and other tools, including tools used to dump the memory
  // of the application, you can place this macro wherever you want,
  // it doesn't change execution of your application in any way
  {$I PELOCK_MEMORY_GAP.INC}

  lblInfo.Caption := 'Hello';

end;

end.
